//
  // Example for using the XbpHTMLViewer Xbase Part
  // to browse a Web site
  //
  #include "XBP.CH"
  #include "AppEvent.CH"
  #pragma Library( "HrfClass.lib" )


  PROCEDURE Main()
   LOCAL oDlg
   LOCAL oHTML
   LOCAL nEvent, mp1, mp2, oXbp
   LOCAL oDA

    //
    // Create application's main dialog
    //
    oDlg := XbpDialog():new( Appdesktop() )
    oDlg:title 	  := "HTML Viewer Example"
    oDlg:taskList := .T.
    oDlg:close    := {|| PostAppEvent(xbeP_Quit,,, oDlg) }
    oDA           := oDlg:drawingArea
    oDlg:create( ,, {50,50}, {640,480},, .F. )

    oDA:resize    := {|| ResizeControl(oHTML)}
 
    //
    // Create the XbpHTMLViewer object
    //
    oHTML := XbpHTMLViewer():new( oDA )
    oHTML:create( ,, {10,10},{450,300}  )
    //
    // Navigate to "www.alaska-software.com"
    //
    oHTML:navigate( "D:\MyTools\XB\Phone.htm" )
    //oHTML:Keyboard := {| nKeyCode, uNIL, self | msgbox("aa") }

    //
    // Display the main dialog and process
    // application events until the dialog
    // is closed
    //
    ResizeControl( oHTML )
    
    oDlg:show()

    SetAppWindow( oDlg )
    SetAppFocus( oHTML )

    //oHTML:progressChange := {| nProgress, nProgressMax, self | di({"progressChange",nProgress, nProgressMax, self}) }
    oHTML:documentComplete := {| cURL, uNIL, self |  di({"documentComplete",cURL, uNIL, self}) }
    //oHTML:statusTextChange := {| cStatus, uNIL, self | di({"statusTextChange",cStatus, uNIL, self}) }
    //di(oHTML:getElementByID( "J-001" ))

    //di({"childList",oHTML:childList()})
    di({"oHTML",oHTML:SetHtml()})
    oDocument := HTMLDocument():new()
    oDocument := oHTML
    di({"xxx",oDocument:cargo})
    

      //oHTML:keyBoard := {| nKeyCode, uNIL, self | di(nKeyCode, uNIL, self) }

    nEvent := xbeP_Quit
    DO WHILE nEvent != xbeP_Close
      nEvent := AppEvent( @mp1, @mp2, @oXbp )
      	 //di({nEvent, mp1, mp2})
      	 if nEvent == xbeP_Keyboard
      	 	msgbox(var2char({nEvent, mp1, mp2}))
      	 	
      	 	 //di({(xbeP_Keyboard-nEvent,50,40),xbeP_Keyboard==nEvent,xbeP_Keyboard,nEvent, mp1, mp2})
      	 endif
      oXbp:handleEvent( nEvent, mp1, mp2 )
    ENDDO

    oDlg:destroy()
  RETURN


  // Resize HTML viewer object to always span the
  // whole of the dialog's drawing area.
  PROCEDURE ResizeControl( oHTML )
    LOCAL oParent := oHTML:setParent()

      oHTML:setPosAndSize( {0,0}, oParent:currentSize() )
  RETURN

  // Overloaded AppSys() procedure to prevent
  // creation of the default XbpCrt window
  PROCEDURE AppSys()
  RETURN


PROCEDURE di(_message,lCond)
LOCAL _FileName := "c:\_DebugInfo.txt"
IF lCond = Nil .OR.  lCond
		_message = var2char(_message)
		_message = DTOS(DATE())+" "+TIME()+":"+CHR(13)+CHR(10)+"  >Call:"+ProcName(1)+"("+ALLTRIM(STR(ProcLine(1)))+")"+CHR(13)+CHR(10)+"  >Mess:"+_message
		IF FILE(_FileName)
		    _message = MemoRead(_FileName)+CHR(13)+CHR(10)+_message
		ENDIF
		IF _message == nil
		    MemoWrit(_FileName, "Null")
		ELSE
		    MemoWrit(_FileName, Var2Char(_message))
		ENDIF
ENDIF
RETURN